/*
 * This File is one of the examples from Java For Beginners
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package multipleConstructors;

import java.util.Objects;

/** 
 * @author Matthew Gregory
 * website: www.matthewgregory-author.com.au
 *
 */
public class Person {

    public String firstName;
    public String lastName;
    public final int ID;
    
    //Constructor with two arguements
    public Person(String firstName, String lastName) {
        setNames(firstName,lastName);
        ID=hashCode();
    }
    
    //Default no-arg constructor defined explicitly
//    public Person() {
//        ID=hashCode();
//    }
    
    //Constructor with a single parameter
//    public Person(String firstName) {
//        setNames(firstName,"unknown");
//        ID=hashCode();
//    }
    //Constructor with a single parameter - using chaining.
    public Person(String firstName) {
        this(firstName,"unknown");
    }
    
    //Default no-arg constructor defined explicitly - using chaining.
    public Person() {
        this("null");
    }
    

    public String getFullName(){
        return firstName+" "+lastName;
    }
    
    public void printDetails(){
        System.out.println("ID: "+ID);
        System.out.println("First Name: "+firstName);
        System.out.println("Last Name: "+lastName);
        System.out.println("Full Name: "+getFullName());
    }
    
    //Using parameters with the same names as the fields
        public void setNames(String firstName, String lastName){
        this.firstName = firstName;
        this.lastName = lastName;
    }  
    
}
